/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.entity;

import neoforge.com.cursee.more_bows_and_arrows.core.entity.ArrowHitsBlockInteractions;
import neoforge.com.cursee.more_bows_and_arrows.core.entity.ArrowHitsEntityInteractions;
import neoforge.com.cursee.more_bows_and_arrows.core.tier.ArrowTier;
import neoforge.com.cursee.more_bows_and_arrows.platform.Services;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class TieredArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(TieredArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ArrowTier tier;

    public TieredArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level, ArrowTier tier) {
        super(entityType, level);
        this.tier = tier;
        this.setVariant(this.tier);
        this.setBaseDamage(this.getBaseDamage() + (double)this.tier.bonusDamage());
    }

    public TieredArrowEntity(double x, double y, double z, Level level, ArrowTier tier) {
        super(Services.PLATFORM.entityFromTier(tier), x, y, z, level, TieredArrowEntity.getPickupItemFromTier(tier), null);
        this.tier = tier;
        this.setVariant(tier);
        this.setBaseDamage(this.getBaseDamage() + (double)this.tier.bonusDamage());
    }

    public TieredArrowEntity(LivingEntity livingEntity, Level level, ArrowTier tier) {
        super(Services.PLATFORM.entityFromTier(tier), livingEntity, level, TieredArrowEntity.getPickupItemFromTier(tier), null);
        this.tier = tier;
        this.setVariant(tier);
        this.setBaseDamage(this.getBaseDamage() + (double)this.tier.bonusDamage());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(ArrowTier tier) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(tier.getId() & 0xFF));
    }

    public ArrowTier getVariant() {
        return ArrowTier.byId(this.getTypeVariant() & 0xFF);
    }

    public float bonusDamage() {
        return this.getVariant().bonusDamage();
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return TieredArrowEntity.getPickupItemFromTier(this.getVariant());
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return TieredArrowEntity.getPickupItemFromTier(this.getVariant());
    }

    @NotNull
    protected static ItemStack getPickupItemFromTier(ArrowTier tier) {
        return new ItemStack((ItemLike)Services.PLATFORM.itemFromTier(tier));
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        ArrowHitsEntityInteractions.interact(this, this.getOwner(), entityHitResult);
        super.onHitEntity(entityHitResult);
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        ArrowHitsBlockInteractions.interact(this, this.getOwner(), blockHitResult);
        super.onHitBlock(blockHitResult);
    }
}

